unit Tokenizer;
{ Ok, this unit seems to be ugly, since it hurts the definition of
 'The Object' - TTokenizer class doesn't encapsulate Code and Data, just Code.
 I've just put this code into a class for later use and for make shareable code,
 'cause i'll use this code frequently. All methods are 'class' methods so you
 don't have to instanting this class! }

{ An important notice: The *first* token has number 1, the second has number 2,
  and so on. There's no token defined to number 0! }  

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes;

{ TTokenizer is a recycled code, the original code (v1.0) looks ugly }
{ v1.01, variable names standardized, put more comments and rewrite methods
  to 'class' methods }
{ v1.02, a bug corrected in GetStringToken() and GetStringTokenStart(), I'm
  just wondering, because I've tested a lot version 1.01 and it worked fine :( }

type
  TTokenizer = class(TObject)
  private
  { private methods }
  class function FirstToken(var NextTokenAt: PChar; TokenSeparator: char;
                            ToTokenize: PChar ): boolean;
{ FirstToken() search the first token in the given 'ToTokenize' PChar string.
  Returns with a PChar pointer, points to the first token in string
  'ToTokenize'. You can define the token separator character with parameter
  'TokenSeparator'. Returns TRUE if a token found else, if no token found it
  returns FALSE. This method used by GetStringToken() and GetStringTokenStart()
  methods. }


  public

{ ----------------------------------------------------------------------------}
{ public methods }
{ ----------------------------------------------------------------------------}
  class function GetStringToken(TokenNo: word; TokenSeparator: char;
                                ToTokenize: PChar; var Token: PChar): boolean;
{ GetStringToken() search the TokenNo'th token in PChar string 'ToTokenize'.
  The TokenNo't token will appear in variable parameter 'Token'. It's your
  responsibilty to allocate 'Token' before you call this method.
  Returning value is TRUE if the TokenNo'th token found, else FALSE.
  You can define the TokenSeparator character with parameter 'TokenSeparator'.}

  class function GetStringTokenStart(TokenNo: word; TokenSeparator: char;
                                     ToTokenize: PChar): PChar;
{ GetStringTokenStart() returns a pointer by the returning value, which
  points to the TokenNo'th token in string 'ToTokenize'. If no such token
  found, returns NIL. }
end;

implementation

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------ tokenizer private/public methods --------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
class function TTokenizer.FirstToken(var NextTokenAt: PChar;
                                         TokenSeparator: char;
                                         ToTokenize: PChar ): boolean;
var tSeparator       : array[1..2] of char;
    tSep             : PChar;
    x                : PChar;
begin
{ if no string... no token! }
     if ToTokenize = nil then begin
        Result:= false;
        Exit;
     end;
{ prepare separator and movin' pointer }
     tSeparator[1]:= TokenSeparator;
     tSeparator[2]:= #0;
     tSep:= addr(tSeparator);
     x:= ToTokenize;

{ jump over starting separators, 'padding}
     while StrPos(x, tSep) = x do
           x:= x + 1;

{ if there's just a terminator, then no token present...}
     if x[0] = #0 then
        FirstToken:= false

{ ... and if there isn't, x eq. the starting char of the token }
     else begin
        FirstToken:= true;
        NextTokenAt:= x;
     end;
end;

{------------------------------------------------------------------------------}

class function TTokenizer.GetStringToken(TokenNo: word; TokenSeparator: char;
                                         ToTokenize: PChar;
                                         var Token: PChar): boolean;
var currentTokenNo   : longint;
    noMoreToken      : boolean;
    tSeparator       : array[1..2] of char;
    tSep             : PChar;
    y, x             : PChar;
begin
{ prepare separator and movin' pointer }
     tSeparator[1]:= TokenSeparator;
     tSeparator[2]:= #0;
     tSep:= addr(tSeparator);
     currentTokenNo:= 0;
     noMoreToken:= false;
     y:= ToTokenize;

{ lookin' for the_tokenNo'th token }
     while (currentTokenNo < TokenNo) and not noMoreToken do begin
           if FirstToken(x, TokenSeparator, y) then
           begin
              y:= StrPos(x, tSep);
              currentTokenNo:= currentTokenNo + 1
           end
           else
              noMoreToken:= true;
     end;
{ if there was a token, copy the corresponding token }
     if (not noMoreToken) and (TokenNo > 0) then
        StrLCopy(Token, x, StrPos(x, tSep) - x);
{ set result }
     GetStringToken:= (not noMoreToken) and (TokenNo > 0);
end;

{------------------------------------------------------------------------------}

class function TTokenizer.GetStringTokenStart(TokenNo: word;
                                              TokenSeparator: char;
                                              ToTokenize: PChar): PChar;
var currentTokenNo   : longint;
    noMoreToken      : boolean;
    tSeparator       : array[1..2] of char;
    tSep             : PChar;
    y, x             : PChar;
begin
{ prepare separator and movin' pointer }
     tSeparator[1]:= TokenSeparator;
     tSeparator[2]:= #0;
     tSep:= addr(tSeparator);
     currentTokenNo:= 0;
     noMoreToken:= false;
     y:= ToTokenize;

{ lookin' for the __tokenNo'th token }
     while (currentTokenNo < TokenNo) and not noMoreToken do begin
           if FirstToken(x, TokenSeparator, y) then
           begin
              y:= StrPos(x, tSep);
              currentTokenNo:= currentTokenNo + 1
           end
           else
              noMoreToken:= true;
     end;
{ if there was a token, return the position, else return *nil* }
     if (not noMoreToken) and (TokenNo > 0) then
         GetStringTokenStart:= x
     else
         GetStringTokenStart:= nil;
end;

end.
